/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.entity;

import com.mrbysco.slabmachines.config.SlabConfig;
import com.mrbysco.slabmachines.init.SlabRegistry;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class TNTSlabEntity
extends PrimedTnt {
    private static final EntityDataAccessor<Boolean> IS_ETHO = SynchedEntityData.m_135353_(TNTSlabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean etho = false;

    public TNTSlabEntity(EntityType<? extends TNTSlabEntity> type, Level level) {
        super(type, level);
    }

    public TNTSlabEntity(Level level, double x, double y, double z, @Nullable LivingEntity igniter, boolean etho) {
        this((EntityType<? extends TNTSlabEntity>)((EntityType)SlabRegistry.TNT_SLAB_ENTITY.get()), level);
        this.m_6034_(x, y, z);
        double d0 = level.f_46441_.nextDouble() * 6.2831854820251465;
        this.m_20334_(-Math.sin(d0) * 0.02, 0.2, -Math.cos(d0) * 0.02);
        this.m_32085_(80);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.f_32072_ = igniter;
        this.etho = etho;
    }

    public TNTSlabEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends TNTSlabEntity>)((EntityType)SlabRegistry.TNT_SLAB_ENTITY.get()), level);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ETHO, (Object)false);
    }

    public void m_32103_() {
        float f = 2.0f;
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), f, Explosion.BlockInteraction.BREAK);
        if (!this.f_19853_.f_46443_ && this.isEtho()) {
            double radius = 6.0f * (0.7f + this.f_19853_.f_46441_.nextFloat() * 0.6f);
            AABB hitbox = new AABB(this.m_20185_() - 0.5, this.m_20186_() - 0.5, this.m_20189_() - 0.5, this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5).m_82363_(-radius, -radius, -radius).m_82363_(radius, radius, radius);
            block0: for (LivingEntity entity : this.f_19853_.m_45976_(LivingEntity.class, hitbox)) {
                if ((!(entity instanceof Player) || entity instanceof FakePlayer) && (!((Boolean)SlabConfig.COMMON.ethoSlabVillagers.get()).booleanValue() || !(entity instanceof Villager))) continue;
                for (int i = 40; i >= 0; --i) {
                    if (entity.m_142538_().m_123342_() + i > 256) {
                        return;
                    }
                    if (this.f_19853_.m_8055_(entity.m_142538_().m_142082_(0, i, 0)).m_60734_() != Blocks.f_50016_) continue;
                    this.f_19853_.m_46597_(entity.m_142538_().m_142082_(0, i, 0), Blocks.f_50323_.m_49966_());
                    continue block0;
                }
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Etho", this.isEtho());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7380_(compound);
        this.setEtho(compound.m_128471_("Etho"));
    }

    public void setEtho(boolean isEtho) {
        this.f_19804_.m_135381_(IS_ETHO, (Object)isEtho);
        this.etho = isEtho;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (IS_ETHO.equals(key)) {
            this.etho = this.getEthoDataManager();
        }
    }

    public boolean getEthoDataManager() {
        return (Boolean)this.f_19804_.m_135370_(IS_ETHO);
    }

    public boolean isEtho() {
        return this.etho;
    }
}

